//=============================================================================
// SoyMeal.
//=============================================================================
class YuckMeal extends MSMTLSoyMeals;

#exec TEXTURE IMPORT NAME="YuckMeal1" FILE="C:\DeusEx\MarkistanCity\Textures\YuckMeal1.pcx" GROUP=Skins
#exec TEXTURE IMPORT NAME="YuckMeal2" FILE="C:\DeusEx\MarkistanCity\Textures\YuckMeal2.pcx" GROUP=Skins
#exec TEXTURE IMPORT NAME="YuckMeal3" FILE="C:\DeusEx\MarkistanCity\Textures\YuckMeal3.pcx" GROUP=Skins

#exec TEXTURE IMPORT NAME=BeltIconSoyMealP2 FILE=Textures\IconSoyMealP2.PCX GROUP=Icons FLAGS=2 //Belt

function inventory SpawnCopy( pawn Other )
{
	local inventory Copy;

	Copy = Super.SpawnCopy(Other);
	Copy.bTossedOut = False;

	return Copy;
}

function DropFrom(vector StartLocation)
{

   if (Level.Netmode != NM_Standalone)
      bTossedOut = true;
	Super.DropFrom(StartLocation);
}

function BecomePickup()
{
	Super.BecomePickup();

   if (Level.NetMode != NM_Standalone)
      if (bTossedOut)
         Lifespan = 15.0;
}

defaultproperties
{
     healAmount=30
     maxCopies=8
     bCanHaveMultipleCopies=True
     InventoryGroup=171
     bActivatable=True
     ItemName="Yuck! Meal"
     PlayerViewOffset=(X=30.000000,Z=-12.000000)
     PlayerViewMesh=LodMesh'DeusExItems.SoyFood'
     PickupViewMesh=LodMesh'DeusExItems.SoyFood'
     ThirdPersonMesh=LodMesh'DeusExItems.SoyFood'
     Icon=Texture'BeltIconSoyMealP2'
     largeIconWidth=42
     largeIconHeight=46
     Description="A sabotaged NUM! Meal, it's been re-written and re-flavored to be less appealing. This one's Liver Purple."
     beltDescription="YUCK MEAL P"
     Skin=Texture'MarkistanCity.Skins.YuckMeal1'
     Mesh=LodMesh'DeusExItems.SoyFood'
     CollisionRadius=8.000000
     CollisionHeight=0.980000
     Mass=3.000000
     Buoyancy=4.000000
}
